import Utilities.gui_creator as gc
import Utilities.nidaq_operations as no
import numpy as np
import threading
import time

root = gc.create_window(title='Digital Thermometer',
                        size='300x100')

channel_name = 'Dev1/ai0'
task = no.create_ai_task(channel_name)

lbl_2 = gc.create_indicator(root,
                            label_1='Temperature (deg Celsius)')

def acquire_sample():
    
    current = 0.0001
    a = 1.12622037e-03
    b = 2.34560173e-04
    d = 8.62708193e-08
    
    while btn.cget('text') == 'Stop':

        voltage = task.read()

        resistance = voltage/current
        x = np.log(resistance)
        inverse_kelvin = a + b*x + d*x**3
        degree_celsius = 1/inverse_kelvin - 273.15
        
        string_temperature = f'{degree_celsius:.1f}'

        lbl_2.config(text=string_temperature)        

        time.sleep(0.1)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')

    t = threading.Thread(target=acquire_sample)
    t.start()

    return

btn = gc.action_button(root,label='Start',
                       action=toggle)

root.mainloop()

task.close()
